<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://vipercache.com
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    ViperCache
 * @subpackage ViperCache/admin
 * @author     Your Name <email@example.com>
 */
class ViperCache_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * The licencing system that handles product licensing
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      DigitalGuard_IT_Licensing_2_3   $license   Licensing System.
	 */
	private $licensing;

	/**
	 * The plugin auto updater system that handles plugin updates
	 *
	 * @since    2.0.4
	 * @access   private
	 * @var      DigitalGuard_IT_Updater_1_1   $autoupdate   Auto Updater System.
	 */
	private $autoupdate;

	/**
	 * An instance of the settings handler class
	 * @since    1.0.0
	 * @access   private
	 * @var      class     $settings    The current instance of the settings handler.
	 */
	private $settings;

	/**
	 * The general settings
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $settings    The current settings of this plugin.
	 */
	private $gen_settings;

	/**
	 * The site cache settings
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $sitecache_settings    The current site cache settings of this plugin.
	 */
	private $sitecache_settings;

	/**
	 * An array of plugins that should be deactivated when using this plugin
	 *
	 * @since    1.1.0
	 * @access   private
	 * @var      array    $pluginList    Array of plugins
	 */
  private $pluginList = array('wp-fastest-cache/wpFastestCache.php' => 'WP Fastest Cache',
                      'wp-rocket/wp-rocket.php' => 'WP Rocket',
                      'wp-super-cache/wp-cache.php' => 'WP Super Cache',
                      'w3-total-cache/w3-total-cache.php' => 'W3 Total Cache',
                      'speed-booster-pack/speed-booster-pack.php' => 'Speed Booster Pack',
                      'autoptimize/autoptimize.php' => 'Autoptimize');

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;

    $this->licensing = new DigitalGuard_IT_Licensing_2_3('8JDWOPBAWBCWM', 'vipercache', 'Viper Cache');
    $this->licensing->update();
		$this->autoupdate = new DigitalGuard_IT_Updater_1_1('5234538F29CBE', CYBVC_PLUGIN_FILE, 'vipercache', 'plugin-update');

		$this->settings = new ViperCache_Settings( $plugin_name, $version );
		$this->gen_settings = $this->settings->get_settings();
		$this->sitecache_settings = $this->settings->get_sitecache_settings();

    add_action('vipercache_cache_clear', 'CYB_Viper_Cache::scheduledCacheClear');
  }

	/**
	 * Load the required dependencies for compatability with third-party plugins.
	 *
	 * @since    2.0.0
	 * @access   private
	 */
	public function load_third_party_dependencies() {

		/**
		 * The class responsible for dealing with Woocommerce compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/woocommerce.php';

		/**
		 * The class responsible for dealing with Easy Digital Downloads compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/easydigitaldownloads.php';

		/**
		 * The class responsible for dealing with Jigoshop compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/jigoshop.php';

		/**
		 * The class responsible for dealing with WPShop compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/wpshop.php';

		/**
		 * The class responsible for dealing with Beaver Builder compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/beaver-builder.php';

		/**
		 * The class responsible for dealing with Thrive Visual Editor compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/thrive-visual-editor.php';

		/**
		 * The class responsible for dealing with Visual Composer compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/visual-composer.php';

		/**
		 * The class responsible for dealing with Thrive Leads compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/thrive-leads.php';

		/**
		 * The class responsible for dealing with WP Rest API compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/wp-rest-api.php';

		/**
		 * The class responsible for dealing with DIVI compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/divi-theme.php';

		/**
		 * The class responsible for dealing with Disqus compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/disqus.php';

		/**
		 * The class responsible for dealing with Advanced Custom Fields compatibility
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/third-party/plugins/advanced-custom-fields.php';
  }

  /**
   * Regenerate config file if an issue is detected.
   *
   * @since 2.0.0
   */
  function regenerate_3rdparty_reject_uri() {

      CYB_Viper_Cache::update_3rdparty_reject_uri();
  }

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles($hook) {
		global $viper_cache_asset_suffix, $viper_cache_page_hooks;
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in ViperCache_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The ViperCache_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
    if(is_null($viper_cache_page_hooks)) return;
    if(!in_array($hook, $viper_cache_page_hooks) )
        return;

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/vipercache-admin' . $viper_cache_asset_suffix . '.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts($hook) {
		global $viper_cache_asset_suffix, $viper_cache_page_hooks;
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in ViperCache_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The ViperCache_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

    if(is_null($viper_cache_page_hooks)) return;
    if(!in_array($hook, $viper_cache_page_hooks) ) return;

    wp_enqueue_script( $this->plugin_name.'-modernizr', plugin_dir_url( __FILE__ ) . 'js/modernizr-custom.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/vipercache-admin' . $viper_cache_asset_suffix . '.js', array( 'jquery' ), $this->version, false );

	}

    /**
	 * Adds the menu options
	 *
	 * @link 		https://codex.wordpress.org/Administration_Menus
	 * @since 		1.0.0
	 * @return 		void
	 */
	public function add_menu() {
		global $viper_cache_page_hooks;

    if(!$this->licensing->is_licensed()) {
      $viper_cache_page_hooks[] = add_menu_page(__("ViperCache - Settings"), __("Viper Cache"), "manage_options", $this->plugin_name . '-settings', array($this, "page_site_settings"), plugin_dir_url( __FILE__ ) . 'images/icon.png');
      $viper_cache_page_hooks[] = add_submenu_page($this->plugin_name. '-settings', __("Settings"), __("Settings"), "manage_options", $this->plugin_name . '-settings', array($this, "page_site_settings"));
    }
    else {
      $viper_cache_page_hooks[] = add_menu_page(__("ViperCache - Settings"), __("Viper Cache"), "manage_options", $this->plugin_name . '-cache-settings', array($this, "page_site_cache_settings"), plugin_dir_url( __FILE__ ) . 'images/icon.png');
      $viper_cache_page_hooks[] = add_submenu_page($this->plugin_name. '-cache-settings', __("Cache Settings"), __("Cache Settings"), "manage_options", $this->plugin_name . '-cache-settings', array($this, "page_site_cache_settings"));
      $viper_cache_page_hooks[] = add_submenu_page($this->plugin_name. '-cache-settings', __("Settings"), __("Settings"), "manage_options", $this->plugin_name . '-settings', array($this, "page_site_settings"));
    }

    do_action($this->plugin_name  . '_admin_menu');

	} // add_menu()

	/**
	 * The viper cache settings Page
	 *
	 * @since 		1.0.0
	 * @return 		void
	 */
	public function page_site_settings() {
  global $wpdb;

		$errors = "";
    $refresh = false;

		$action = empty( $_REQUEST['action'] ) ? '' : $_REQUEST['action'];
		if($action == 'vipercache_save_settings') {

      $errors = CYB_Viper_Cache::cacheDirectoryTest();

      $values = isset($_REQUEST['vipercache-settings-options']) ? $_REQUEST['vipercache-settings-options'] : array();

      $current_key = $this->licensing->get_license_key();
      $license_key = isset($values['license_key']) ? trim($values['license_key']) : "";

      // If license key entered
      if(!empty($license_key)) {
        if($current_key != $license_key) {
          if(!empty($current_key)) $this->licensing->revoke_license($current_key);
          $this->licensing->validate_license($license_key);
          $refresh = true;
        }
      }
      else if(empty($license_key) && !empty($current_key)) {
        $this->licensing->revoke_license($current_key);
        $refresh = true;
      }

      unset($values['license_key']);

    }

    if($refresh) {
      echo '<script>location.reload();</script>';
    	exit;
    }

		include( plugin_dir_path( __FILE__ ) . 'partials/vipercache-admin-page-settings.php' );
	}

	/**
	 * The viper cache  cache settings Page
	 *
	 * @since 		1.0.0
	 * @return 		void
	 */
	public function page_site_cache_settings() {
		global $wpdb;

		$errors = "";
    $message = "";
    $preload = false;

		$action = empty( $_REQUEST['action'] ) ? '' : $_REQUEST['action'];
    if($action == 'vipercache_save_sitecache_setup' && $_REQUEST['submit'] == 'Reset Cache' ) {
      do_action('vipercache_cache_clear');
      $preload = true;
    }
		else if($action == 'vipercache_save_sitecache_setup') {

			$values = isset($_REQUEST['vipercache-sitecache-options']) ? $_REQUEST['vipercache-sitecache-options'] : array();

			$values['active'] = isset($values['active']) ? $values['active'] : "N";
      $values['cacheHTTPS'] = isset($values['cacheHTTPS']) ? $values['cacheHTTPS'] : "N";
      $values['deferJS'] = isset($values['deferJS']) ? $values['deferJS'] : "N";
      $values['disableEmojis'] = isset($values['disableEmojis']) ? $values['disableEmojis'] : "N";
      $values['removeVerQS'] = isset($values['removeVerQS']) ? $values['removeVerQS'] : "N";
      $values['combineCSS'] = isset($values['combineCSS']) ? $values['combineCSS'] : "N";
      $values['combineJS'] = isset($values['combineJS']) ? $values['combineJS'] : "N";
      $values['fixImgDim'] = isset($values['fixImgDim']) ? $values['fixImgDim'] : "N";
      $values['fixImgHL'] = isset($values['fixImgHL']) ? $values['fixImgHL'] : "N";
      $values['blockBots'] = isset($values['blockBots']) ? $values['blockBots'] : "N";
      $values['stopRenderBlockCSS'] = isset($values['stopRenderBlockCSS']) ? $values['stopRenderBlockCSS'] : "N";

      // Deal with doNotCacheUrls
  	  if ( !empty($values['doNotCacheUrls']) ) {

    		if ( ! is_array( $values['doNotCacheUrls'] ) ) {
    			$values['doNotCacheUrls'] = explode( "\n", $values['doNotCacheUrls'] );
    		}
    		$values['doNotCacheUrls'] = array_map( 'trim', $values['doNotCacheUrls'] );
        $values['doNotCacheUrls'] = array_map( 'esc_url', $values['doNotCacheUrls'] );
        $values['doNotCacheUrls'] = array_map( 'CYB_Viper_Cache::clean_url', $values['doNotCacheUrls'] );
        $values['doNotCacheUrls'] = (array) array_filter( $values['doNotCacheUrls'] );
        $values['doNotCacheUrls'] = array_unique( $values['doNotCacheUrls'] );
	    }
      else {
		      $values['doNotCacheUrls'] = array();
	    }

      // Deal with doNotCacheJS
  	  if ( !empty($values['doNotCacheJS']) ) {

    		if ( ! is_array( $values['doNotCacheJS'] ) ) {
    			$values['doNotCacheJS'] = explode( "\n", $values['doNotCacheJS'] );
    		}
    		$values['doNotCacheJS'] = array_map( 'trim', $values['doNotCacheJS'] );
        $values['doNotCacheJS'] = array_map( 'esc_url', $values['doNotCacheJS'] );
        // $values['doNotCacheJS'] = array_map( 'CYB_Viper_Cache::clean_url', $values['doNotCacheJS'] );
        $values['doNotCacheJS'] = (array) array_filter( $values['doNotCacheJS'] );
        $values['doNotCacheJS'] = array_unique( $values['doNotCacheJS'] );
	    }
      else {
		      $values['doNotCacheJS'] = array();
	    }

      // Deal with criticalCSS
			$values['criticalCSS'] = isset($values['criticalCSS']) ? stripslashes($values['criticalCSS']) : "";

      // If the cache is on and settings changed then clear cache
      if($this->sitecache_settings != $values) {
        do_action('vipercache_cache_clear');
        CYB_Viper_Cache::updateSettings($values);
        $preload = true;
      }

      if($values['active'] == 'Y') {
        // If cache switched back on then make sure that the htaccess file is updated to match the settings
        if($this->sitecache_settings['active'] != $values['active']
           || $this->sitecache_settings['fixImgHL'] != $values['fixImgHL']
           || $this->sitecache_settings['blockBots'] != $values['blockBots']) {

          $err = CYB_Viper_Cache::addHtaccessCode('add');
  				if($err) {
            $errors = "Could not edit .htaccess. The error was: " . $err;
  			  }
        }

        // Any Values changed then pre-load the cache (it would have been cleared before this point)
        if($this->sitecache_settings != $values ) {
          $preload = true;
        }
      }
      else if($values['active'] == 'N') {
        $preload = false;
        do_action('vipercache_cache_clear');
        $err = CYB_Viper_Cache::addHtaccessCode('remove');
				if($err) {
          $errors = "Could not edit .htaccess. The error was: " . $err;
			  }
      }

      // Update the list of 3rd party rejected uri
      CYB_Viper_Cache::update_3rdparty_reject_uri();

      $message = "<div class='updated'>Your changes have been saved.</div>";

			$this->sitecache_settings = wp_parse_args( $values, $this->sitecache_settings );
			$this->settings->set_sitecache_settings($this->sitecache_settings);

		}

		$this->sitecache_settings = $this->settings->get_sitecache_settings();

    if($preload) {
      CYB_Viper_Cache::start_cache_preload();
    }

		include( plugin_dir_path( __FILE__ ) . 'partials/vipercache-cache-settings.php' );
	}

	/**
	 * Add a clear cache option to the admin menu bar
	 *
	 * @since 		1.0.9
	 * @return 		void
	 */
  function admin_bar_menu( $wp_admin_bar ) {
    global $current_screen;

    if(!is_admin()) return;
    if($this->sitecache_settings['active'] != 'Y') return;
    if(isset($current_screen) && $current_screen->id == 'viper-cache_page_vipercache-cache-settings') return;

    $html = "<span class='cybvc-admin-bar-icon' style='float:left; margin-top: 5px !important; margin-right: 5px !important;line-height:20px;'><img src='".plugin_dir_url( __FILE__ ) . "images/icon.png'></span> Clear Cache";

    $args = array('id'    => CYBVC_SLUG . '_clear_cache',
        'title' => $html, 'href'  => '#',
        'meta'  => array(
            'onclick' => CYBVC_SLUG . '_clear_cache()',
            'title' => 'Clear out the Viper Cache cache'
        )
    );
    $wp_admin_bar->add_node( $args );
  }

	/**
	 * Injects the javascript to deal with clearing the cache
	 *
	 * @since 		1.0.9
	 * @return 		void
	 */
  function admin_head(){
?>
    <script>
        function <?php echo CYBVC_SLUG; ?>_clear_cache(){
            if(!confirm('Are sure you want to clear out the cache?')) return;
            jQuery.post(ajaxurl, {'action': '<?php echo CYBVC_SLUG; ?>_clear_cache'}, function(response) {
                alert('The Cache Has Been Cleared!');
            });
        }
    </script>
<?php
  }

	/**
	 * AJAX function to clear out the cache
	 *
	 * @since 		1.0.9
	 * @return 		void
	 */
  function clear_cache() {

    CYB_Viper_Cache::clearPageCacheSafe();
    die(0);
  }


}
