<?php
/**
 * The metabox-specific functionality of the plugin.
 *
 * @link       http://vipercache.com
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/admin
 */

wp_nonce_field( $this->plugin_name, 'disable_cache' );

$atts 					= array();
$atts['class'] 			= 'widefat';
$atts['description'] 	= '';
$atts['id'] 			  = 'vipercache-disable-cache-uris';
$atts['label'] 			= 'Cache This Page';
$atts['name'] 			= 'vipercache-disable-cache-uris';
$atts['type'] 			= 'select';
$atts['value'] 			= 'Y';
$atts['aria'] 			= '';

if ( ! empty( $this->meta[$atts['id']] ) ) {
  $disable_cache_uris = array_flip( $this->meta[$atts['id']] );
  $path = CYB_Viper_Cache::clean_uri( get_permalink( $post->ID ) );
  if ( isset( $disable_cache_uris[ $path ] ) ) {
    $atts['value'] = 'N';
  }
}
$atts['selections'] = Array(Array('label' => 'Use Default Settings', 'value' => 'Y'), Array('label' => 'No', 'value' => 'N'));
?>
<p>
<?php

include( plugin_dir_path( __FILE__ ) . $this->plugin_name . '-admin-field-select.php' );

?>
</p>
