<?php
/**
 * Provide a admin area view for settings
 *
 * This file is used to markup the admin-facing aspects of the plugin settings page.
 *
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/admin/partials
 */

 global $wp_version;
?>
<div class="wrap">
<div class="branding clearfix">
 <div class="logo">
  <img class="logo" src="<?php echo plugin_dir_url( __FILE__ ) . 'images/wpvipc-small-logo.png';?>">
 </div>
 <h1 class="page-title"><?php echo esc_html( get_admin_page_title() ); ?></h1>
</div>
<?php if ( version_compare( $wp_version, '4.5', '<' ) ) {
  echo '<div class="notice notice-error">This Plugin requires at least version 4.5 of WordPress. Please update your WordPress to the latest version in order to avoid any compatibility issues.</div>';
}
foreach ($this->pluginList as $plugin => $name) {
  if (is_plugin_active( $plugin ) ) {
    echo '<div class="error">';
    echo "<p>$name is currently active. It is not recommended to have more than one cache running as it may cause unexpected results. Please Deactivate It.</p>";
    echo '</div>';
  }
}
?>
<?php if(!empty($errors)) { ?>
<div class="notice notice-error"><?php echo $errors;?></div>
<?php } ?>
<form method="post" action="">
<input type="hidden" name="action" value="vipercache_save_settings">
<?php if($this->licensing->is_licensed()) { ?>
<div class="dgit_status msg">
    <p>Viper Cache is licensed. If you wish to unlicense then delete the current license and click  'Save Changes'.</p>
<?php } else { ?>
<div class="dgit_error">
<p>First you need to activate Viper Cache by entering your license key in box below.</p>
<p>If you purchased via JVZoo then the license key is the transaction id and you can also find it in your <a href="https://customer.jvzoo.com/portal/index" target="_blank">JVZoo customer portal</a> under your Viper Cache download details. Your JVZoo transaction ID will look like this: AP-12345678912345678.</p>
<p>If you purchased via Warrior Plus then the license key can be found on the download page which you can access via the <a href="https://warriorplus.com/buy/history" target="_blank">Purchase History</a> section. Just click on the Viper Cache link, then click the "Access Your Purchase" link to access the download page. Your Warrior license key will look like this: wplus_abc12345.</p>
<p>If you purchased via Clickbank then the license key can be found on the download page which you can access via the Download Link in the 'Receipt For Order' email you would have received after purchase. Your Clickbank license key will look like this: cbank_XXXXXXXX.</p>
<p>When you have entered your licence key below, click the "Save Changes" button to activate you license.</p>
<?php } ?>
 <table class="form-table">
  <tbody>
  <tr>
      <th scope="row">License Key</th>
      <td>
        <div class="dgit_group">
          <input type="password" class="dgit_key regular-text" name="vipercache-settings-options[license_key]" placeholder="Enter license key" value="<?php echo $this->licensing->get_license_key();?>">
          <?php if($this->licensing->has_error()) { ?>
           <div class="dgit_error msg">
            <?php echo $this->licensing->get_error(); ?>
           </div>
        <?php } else {
            $licenseData = $this->licensing->get_license_data();
            if(!empty($licenseData)) {
              echo '<div class="dgit_status msg"><span>License Status:</span> '.ucfirst(strtolower($licenseData->status)).' <span><br>Product:</span> '.$licenseData->product_name;
              if($this->licensing->has_license_message()) { echo '<br>'.$this->licensing->get_license_message(); }
              echo '</div>';
            }
          } ?>
       </div>
      </td>
    </tr>
  </tbody>
 </table>
 <p class="submit"><input type="submit" value="Save Changes" class="button button-primary" id="submit" name="submit"></p>
</form>
</div>
