<?php
/**
 * Provide a admin area view for the viper cache settings
 *
 * This file is used to markup the admin-facing aspects of the plugin viper cache settings page.
 *
 * @since      1.0.0
 *
 * @package    Post_Gopher
 * @subpackage Post_Gopher/admin/partials
 */

$stats = CYB_Viper_Cache::getCacheStats();
if($stats['files'] > 0)
  $stats['display-percentage'] = round( 100 - ($stats['compressedBytes'] / $stats['uncompressedBytes'] * 100));
else
  $stats['display-percentage'] = 0;
$preloading = $preload || get_transient( 'CYB_Viper_Cache_Preload' );

?>
<div class="wrap">
<div class="branding clearfix">
 <div class="logo">
  <img class="logo" src="<?php echo plugin_dir_url( __FILE__ ) . 'images/wpvipc-small-logo.png';?>">
 </div>
 <h1 class="page-title"><?php echo esc_html( get_admin_page_title() ); ?></h1>
</div>
<?php
foreach ($this->pluginList as $plugin => $name) {
  if (is_plugin_active( $plugin ) ) {
    echo '<div class="error">';
    echo "<p>$name is currently active. It is not recommended to have more than one cache running as it may cause unexpected results. Please Deactivate It.</p>";
    echo '</div>';
  }
}

// if( defined( 'DONOTCACHEPAGE' ) && DONOTCACHEPAGE ) {
//   echo '<div class="error">';
//   echo "<p>The WordPress DONOTCACHEPAGE constant is set as TRUE. No caching will occur until this is set to FALSE.</p>";
//   if(is_plugin_active('wordfence/wordfence.php'))
//     echo "<p>You have the Wordfence Security plugin active and it is known to set the DONOTCACHEPAGE constant.</p>";
//   if(is_plugin_active('webinar_optin_2/smsWebinar.php'))
//     echo "<p>You have the webinarOPTIN plugin active and it is known to set the DONOTCACHEPAGE constant.</p>";
//   echo '</div>';
//   echo '</div>';
// }

if(!empty($errors)) { ?>
<div class="notice notice-error"><?php echo $errors;?></div>
<?php } ?>
<?php if(!empty($message)) { ?>
<?php echo $message;?>
<?php } ?>
<form method="post" action="">
 <input type="hidden" name="action" value="vipercache_save_sitecache_setup">
 <table class="form-table site-cache">
  <tbody>
    <tr class="info">
     <td colspan="2">
      <p class="info"><strong>WELCOME TO VIPER CACHE</strong></p>
      <p class="info">Before you enable Viper Cache you may wish to perform your own speed tests using <a href="https://tools.pingdom.com/" target="_blank">Pingdom</a> - please note these services are NOT 100% accurate as the results will fluctuate with internet traffic.</p>
      <p class="info">Simply enable the cache and decide whether HTTPS caching best suits your site then test your site to make sure everything works as before.</p>
      <p class="info">99% of sites will work fine with the default options we selected for you - in the unlikely event that your site doesn't work as it should: turn off all the cache options below & turn on each option one by one until you isolate the problem.</p>
      <p class="info">Enjoy!</p>
     </td>
    </tr>
  </tbody>
 </table>
 <table class="form-table site-cache settings">
  <tbody>
   <tr>
    <th scope="row"><?php _e( 'Enable Viper Cache'); ?></th>
    <td>
     <label class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[active]" value="Y" <?php checked( 'Y', $this->sitecache_settings['active']); ?>/>
      <span class="lbl"></span>
     </label>
<?php if(!is_multisite()) { ?>
     <span class="description">This option enables your cache, blocks known bad bots, fake search engines & scrapers. <span class="reminder">(Don't forget to Click  Save Changes)</span></span>
<?php } else { ?>
     <span class="description">This option enables your cache. <span class="reminder">(Don't forget to Click  Save Changes)</span></span>
<?php } ?>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e('HTTPS Caching'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[cacheHTTPS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['cacheHTTPS']); ?>/>
      <span class="lbl"></span>
     </label>
<?php if($this->sitecache_settings['cacheHTTPS']  == 'N' && CYB_Viper_Cache::isHTTPSSite()) { ?>
     <span class="description"><span class="reminder">HTTPS site detected</span> - We recommend you switch this setting to on to enable caching of your site. But only if your site doesn't store sensitive data in the pages.</span>
<?php } else { ?>
     <span class="description">Enable this on HTTPS sites but only if your site doesn't store sensitive data in the pages. (default: disabled)</span>
<?php } ?>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e('Defer JavaScript\'s'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[deferJS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['deferJS']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This loads all JavaScript's after your page loads increasing speed. Enable if you're not running any page critical scripts. (default: enabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Disable Emojis'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[disableEmojis]" value="Y" <?php checked( 'Y', $this->sitecache_settings['disableEmojis']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This feature stops WordPress default emojis & emoji scripts from loading. (default: enabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'CSS & JS Cache'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[removeVerQS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['removeVerQS']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">Most cache products don't cache JS & CSS files as WordPress alters the URL with version info - this fixes that problem. (default: enabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Minimize CSS'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[combineCSS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['combineCSS']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This reduces the number of CSS files by combining them increasing load speed. (default: enabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Minimise JS'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[combineJS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['combineJS']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This reduces the number of JavaScript files by combining them increasing load speed. (default: enabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Fix Image Sizes'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[fixImgDim]" value="Y" <?php checked( 'Y', $this->sitecache_settings['fixImgDim']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This feature scans your media images & inserts width & height attributes allowing for faster image rendering. (default: disabled)</span>
    </td>
   </tr>
<?php if(!is_multisite()) { ?>
   <tr class="thin">
    <th scope="row"><?php _e( 'Prevent Image Hotlinking'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[fixImgHL]" value="Y" <?php checked( 'Y', $this->sitecache_settings['fixImgHL']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This feature will prevent images on your website being link to from other websites. (default: disabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Block Bad Bots'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[blockBots]" value="Y" <?php checked( 'Y', $this->sitecache_settings['blockBots']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This feature will prevent known bad bots from crawling and scraping your site. (default: disabled)</span>
    </td>
   </tr>
   <tr class="thin">
    <th scope="row"><?php _e( 'Eliminate Render Blocking CSS'); ?></th>
    <td>
     <label  class="ace-switch">
      <input type="checkbox" class="ace ace-switch ace-switch-4 btn-empty" name="vipercache-sitecache-options[stopRenderBlockCSS]" value="Y" <?php checked( 'Y', $this->sitecache_settings['stopRenderBlockCSS']); ?>/>
      <span class="lbl"></span>
     </label>
     <span class="description">This feature will optimize CSS delivery and help eliminate render-blocking resources. You must have Minimize CSS On Also (default: disabled)</span>
    </td>
   </tr>
<?php } ?>
   <tr>
    <td colspan="2">
      <p><strong>Please note:</strong> You can turn off cache for individual pages/posts in the WordPress editor</p>
    </td>
   </tr>
   <tr>
    <td colspan="2">
      <hr>
      <p class="info"><strong>Advanced Settings</strong></p>
      <p>These options are for advanced cache use. Under most circumstances caching will work without the need to use these settings.
    </td>
   </tr>
   <tr>
    <th class="top" scope="row"><?php _e( 'Do Not Cache These Urls'); ?></th>
    <td>
     <label  class="ace-switch">
      <textarea id="doNotCacheUrls" name="vipercache-sitecache-options[doNotCacheUrls]" cols="70" rows="5" placeholder="/membersarea/(.*)"><?php
        $taValue = $this->sitecache_settings['doNotCacheUrls'];
      	if ( is_array( $taValue ) ) {
					$taValue = implode( "\n" , $taValue );
				}
        echo esc_html( esc_textarea( $taValue ) );
      ?></textarea>

      <span class="lbl"></span>
    </label><br>
     <span class="description">The domain part of the URL will automatically be stripped off.<br>You can use wildcards (.*) to address URLs under the same path. One Entry Per Line.</span>
<?php
if ( function_exists( 'WC' ) && function_exists( 'wc_get_page_id' ) ) {
  echo '<p class="info"><strong>WooCommerce</strong> Cart and checkout pages are automatically detected and never cached. You do not need to enter them above.';
}
elseif ( function_exists( 'EDD' ) ) {
  echo '<p class="info"><strong>Easy Digital Downloads</strong> Cart and checkout pages are automatically detected and never cached. You do not need to enter them above.';
}
elseif ( defined( 'JIGOSHOP_VERSION' ) && function_exists( 'jigoshop_get_page_id' ) ) {
  echo '<p class="info"><strong>Jigoshop</strong> Cart and checkout pages are automatically detected and never cached. You do not need to enter them above.';
}
elseif ( defined( 'WPSHOP_VERSION' ) && class_exists( 'wpshop_tools' ) && method_exists( 'wpshop_tools','get_page_id' ) ) {
  echo '<p class="info"><strong>WP-Shop</strong> Cart and checkout pages are automatically detected and never cached. You do not need to enter them above.';
}
?>
    </td>
   </tr>
   <tr>
    <th class="top" scope="row"><?php _e( 'Do Not Cache These Javascript Files'); ?></th>
    <td>
     <label  class="ace-switch">
      <textarea id="doNotCacheJS" name="vipercache-sitecache-options[doNotCacheJS]" cols="100" rows="5" placeholder="jquery(|.min).js"><?php
        $taValue = $this->sitecache_settings['doNotCacheJS'];
      	if ( is_array( $taValue ) ) {
					$taValue = implode( "\n" , $taValue );
				}
        echo esc_html( esc_textarea( $taValue ) );
      ?></textarea>

      <span class="lbl"></span>
    </label><br>
     <span class="description">Use this for JavaScript files that are on the same domain as your site.<br>You can use wildcards (.*) to address Names/URLs. One Entry Per Line</span>
    </td>
   </tr>
   <tr>
		<th class="top" scope="row"><?php _e( 'Critical CSS'); ?></th>
		<td>
      <textarea id="criticalCSS" name="vipercache-sitecache-options[criticalCSS]" cols="100" rows="5" placeholder=""><?php
        echo esc_html( esc_textarea( $this->sitecache_settings['criticalCSS'] ) );
      ?></textarea>
			<br>
	    <span class="description">Use this to provide the critical CSS for your site. This is the CSS that is used to style your site whilsts the cached CSS is being loaded.<br>You can find various site on the internet that can help you generate the critical css for your site.
    </td>
   </tr>
   <tr>
    <td colspan="2">
      <hr>
      <p><input type="submit" value="Save Changes" class="button button-primary" id="submit" name="submit"></p>
    </td>
   </tr>
   <tr class="info">
    <td colspan="2">
     <p class="info">Cache clearing will happen automatically when you change any page/post or when you install new plugins so there's no need to manually clear cache like on other products.</p>
     <p class="info">Where images or content on your page are created by external sites or outside WordPress either update the page or reset the cache using the button below.</p>
     <p class="info">Our smart cache preloading feature will preload the cache with your home page + 5 of your most popular pages - this is a unique bandwidth saving feature as on large sites cache preloading will tie up your processor, slow down your site & eat bandwidth.</p>
    </td>
   </tr>
  </tbody>
 </table>
 <table class="widefat site-cache-statistics">
  <tbody>
   <tr class="thin">
    <th class="text-center" scope="row" colspan="4"><h3>Cache Statistics</h3></th>
   </tr>
   <tr>
     <td class="panel text-center">
      <div class="infobox-data">
       <span class="infobox-text">Pages In Cache</span>
       <span class="infobox-icon"><span class="dashicons dashicons-admin-page"></span></span>
       <span class="infobox-data-number"><?php echo $stats['files'];?> Pages / <?php echo CYB_Viper_Cache::format_filesize_kB($stats['compressedBytes'] / 1024);?></span>
      </div>
     </td>
     <td class="panel text-center">
      <div class="infobox-data">
       <span class="infobox-text">HTML Optimisation</span>
       <div class="progress-circle-container">
         <div class="progress-circle progress-<?php echo $stats['display-percentage'];?>"><span><?php echo $stats['display-percentage'];?></span></div>
       </div>
       <span class="infobox-data-number"><?php echo CYB_Viper_Cache::format_filesize_kB($stats['uncompressedBytes'] / 1024);?>&nbsp;<small>(original)</small> / <?php echo CYB_Viper_Cache::format_filesize_kB($stats['compressedBytes'] / 1024);?>&nbsp;<small>(optimized)</small></span>
      </div>
     </td>
     <td class="panel text-center">
      <div class="infobox-data">
       <span class="infobox-text">Largest File</span>
       <span class="infobox-icon"><span class="dashicons dashicons-format-aside"></span></span>
       <span class="infobox-data-number"><?php echo CYB_Viper_Cache::format_filesize_kB($stats['largestFile'] / 1024);?></span>
      </div>
     </td>
     <td class="panel text-center">
      <div class="infobox-data">
       <span class="infobox-text">History</span>
       <span class="infobox-icon"><span class="dashicons dashicons-clock"></span></span>
       <span class="infobox-data-number">
<?php
			if(time() -$stats['oldestFile'] < 300) {
				$data = (time() -$stats['oldestFile']) . ' seconds ago';
			} else {
				$data = human_time_diff($stats['oldestFile']) . ' ago.';
			}
      echo "Oldest File: ".$data."<br>";
      if(time() -$stats['newestFile'] < 300) {
				$data = (time() -$stats['newestFile']) . ' seconds ago';
			} else {
				$data = human_time_diff($stats['newestFile']) . ' ago.';
			}
      echo "Newest File: ".$data."<br>";
?>
       </span>
      </div>
     </td>
    </tr>
<?php if($preloading === false && $stats['files'] == 0) { ?>
   <tr class="info text-center">
    <td colspan="4"><h2>The cache is currently empty. It may not be active or been recently cleared.</h2></td>
   </tr>
<?php } else if($preloading !== false) { ?>
   <tr>
    <td colspan="4" class="text-center">
    <h4>Your cache has been cleared & Viper Cache is now preloading your most popular pages... Please Refresh Later.</h4>
    </td>
   </tr>
<?php } ?>
   <tr class="info">
    <td colspan="4">
     <p class="info"><strong>DISABLING & CLEARING THE CACHE</strong></p>
     <p class="info">To clear the cache - simply disable the plugin - its that simple.</p>
     <p class="info"><strong>RESETTING THE CACHE</strong></p>
     <p class="info">The "Reset Cache" feature helps you clear & automatically rebuild the cache of your most popular pages, this is handy if you are linking to external content such as ad networks or images for the 1st time.</p>
     <p class="info"><strong>We recommend you reset cache after editing or adding new pages - this is not necessary as the cache will rebuild naturally but it's useful if you want peak performance on the top pages instantly. </strong></p>
<?php if($preloading === false && $stats['files'] > 0) { ?>
      <input type="submit" value="Reset Cache" class="button button-primary button-small" id="submit" name="submit">
<?php }
if(is_main_site()) {
?>
     <p class="info"></p>
     <p class="info"><strong>PRODUCT REMOVAL</strong></p>
     <p class="info">Disabling the product here or in your plugin manager will disable & clear the cache</p>
     <a href="<?php echo CYB_Viper_Cache::getCacheURL();?>htaccess.backup" class="button button-primary button-small download" download>Download original htaccess file</a>
     <p class="info">If you remove the plugin manually via FTP the cache will still be active. To disable the cache this way you must download the original htaccess (using the button above). rename the existing .htaccess  to htaccess.old - upload the htacces.backup to the root folder & rename it to htaccess (see tutorial videos)</p>
<?php } ?>
    </td>
   </tr>
   </tbody>
  </table>
 </form>
</div>
