<?php
/**
 * Handles common base functions for the css/js combination & minification classes
 *
 * @link       http://vipercache.com
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes
 */

	class CYB_base_Utilities{

		public function find_tags($start_string, $end_string, $source = false){
			if($source){
				$data = $source;
			}else{
				$data = $this->html;
			}

			$list = array();
			$start_index = false;
			$end_index = false;

			for($i = 0; $i < strlen( $data ); $i++) {
			    if(substr($data, $i, strlen($start_string)) == $start_string){
			    	$start_index = $i;
				}

				if($start_index && $i > $start_index){
					if(substr($data, $i, strlen($end_string)) == $end_string){
						$end_index = $i + strlen($end_string)-1;
						$text = substr($data, $start_index, ($end_index-$start_index + 1));

						array_push($list, array("start" => $start_index, "end" => $end_index, "text" => $text));

						$start_index = false;
						$end_index = false;
					}
				}
			}

			return $list;
		}

    public function read_file($url) {
  		if(!preg_match("/\.php/", $url)) {
  			$url = preg_replace("/\?.*/", "", $url);
  			$path = preg_replace("/.+\/wp-content\/(.+)/", WP_CONTENT_DIR."/"."$1", $url);

  			if(file_exists($path)){
  				$filesize = filesize($path);

  				if($filesize > 0){
  					$myfile = fopen($path, "r") or die("Unable to open file!");
  					$data = fread($myfile, $filesize);
  					fclose($myfile);

  					return $data;
  				}else{
  					return false;
  				}
  			}
  		}

  		return false;
  	}

  	public function createFolder($cachFilePath, $buffer, $extension, $prefix = ""){

			if($buffer && strlen($buffer) > 5) {
				$buffer = trim($buffer);
        if($extension == "js") {
					if(substr($buffer, -1) != ";") {
						$buffer .= ";";
					}
				}

					if(!is_dir($cachFilePath)){
              @mkdir($cachFilePath, 0755, true);
							@file_put_contents($cachFilePath."/".$prefix."index.".$extension, $buffer);

	   					if(!file_exists(CYB_Viper_Cache::getCachePath() . 'minified/index.html')){
			   					@file_put_contents(CYB_Viper_Cache::getCachePath() . 'minified/index.html', "");
	   					}
					}
          else{
							@file_put_contents($cachFilePath."/".$prefix."index.".$extension, $buffer);
					}
				}
      else {
				$this->err = "Buffer is empty so the minified cache cannot be created";
			}
		}

    protected function canReadFile($path)
    {
        return strlen($path) < PHP_MAXPATHLEN && @is_file($path) && is_readable($path);
    }

    protected function canReadBySize($path)
    {
        return ($size = @filesize($path)) && $size <= 5120;
    }

	}
