<?php

/**
 * The class to handle the settings for the plugin
 *
 *
 * @link       http://vipercache.com
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes
 */

/**
 * The plugin settings class.
 *
 * This is used to deal with the settings used by the plugin, store and retrieves
 * the settings providing default where none currently set.
 *
 * @since      1.0.0
 * @package    ViperCache
 * @subpackage ViperCache/includes
 * @author     Your Name <email@example.com>
 */
class ViperCache_Settings {

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct( $plugin_name, $version ) {

			$this->plugin_name = $plugin_name;
			$this->version = $version;
	}

	/**
	 * Returns the pluign general settings
	 *
	 * @since    1.0.0
	 */
	public function get_settings() {

		$gen_settings = get_option($this->plugin_name. '-options');

		// Set defaults if needed

		return $gen_settings;
	}

  /**
   * Sets the general settings
   *
   * @since    1.0.0
   */
  public function set_settings($gen_settings) {
		update_option($this->plugin_name. '-options', $gen_settings);
  }

  /**
	 * Returns the site cache Settings
	 *
	 * @since    1.0.0
	 */
	public function get_sitecache_settings() {
		$sitecache_settings = get_option($this->plugin_name. '-sitecache-options');

		if(!isset($sitecache_settings['active'])) $sitecache_settings['active'] = 'N';
    if(!isset($sitecache_settings['cacheHTTPS'])) $sitecache_settings['cacheHTTPS'] = 'N';
    if(!isset($sitecache_settings['deferJS'])) $sitecache_settings['deferJS'] = 'Y';
    if(!isset($sitecache_settings['disableEmojis'])) $sitecache_settings['disableEmojis'] = 'Y';
    if(!isset($sitecache_settings['removeVerQS'])) $sitecache_settings['removeVerQS'] = 'Y';
    if(!isset($sitecache_settings['combineCSS'])) $sitecache_settings['combineCSS'] = 'Y';
    if(!isset($sitecache_settings['combineJS'])) $sitecache_settings['combineJS'] = 'Y';
    if(!isset($sitecache_settings['fixImgDim'])) $sitecache_settings['fixImgDim'] = 'N';
    if(!isset($sitecache_settings['fixImgHL'])) $sitecache_settings['fixImgHL'] = 'N';
    if(!isset($sitecache_settings['blockBots'])) $sitecache_settings['blockBots'] = 'N';
    if(!isset($sitecache_settings['doNotCacheUrls'])) $sitecache_settings['doNotCacheUrls'] = array();
    if(!isset($sitecache_settings['doNotCacheJS'])) $sitecache_settings['doNotCacheJS'] = array();
    if(!isset($sitecache_settings['stopRenderBlockCSS'])) $sitecache_settings['stopRenderBlockCSS'] = 'N';
    if(!isset($sitecache_settings['criticalCSS'])) $sitecache_settings['criticalCSS'] = '';

		return $sitecache_settings;
	}

	/**
		* Sets the site cache settings into the Wordpress options
		*
		* @since    1.0.0
		*/
	public function set_sitecache_settings($sitecache_settings) {
		update_option($this->plugin_name. '-sitecache-options', $sitecache_settings );
	}
}
