<?php
/**
 * Handles compatibility with Advanced Custom Fields plugin
  *
 * @link       http://vipercache.com
 * @since      2.0.2
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

/**
 * Clear cache when ACF options page is updated.
 *
 * @param string $post_id ACF options page ID is 'options'.
 */
function viper_cache_acf_options_save( $post_id ) {
	if ( 'options' === $post_id ) {
    CYB_Viper_Cache::clearPageCacheSafe();
	}
}

add_action( 'acf/save_post', 'viper_cache_acf_options_save' );
