<?php
/**
 * Handles compatibility with Beaver Builder, clears the cache when the BB layout is updated
  *
 * @link       http://vipercache.com
 * @since      2.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( defined( 'FL_BUILDER_VERSION' ) ) {
	/**
	 * Clears the cache when the BB layout is updated
	 *
	 * @since 2.0.0
	 */
	function viper_cache_beaver_builder_clear_cache() {

    CYB_Viper_Cache::clearPageCacheSafe();

	}

	add_action( 'fl_builder_before_save_layout', 'viper_cache_beaver_builder_clear_cache', 10, 4 );

}
