<?php
/**
 * Handles compatibility with Disqus Comment System, adds various files to excluded JS Files list
 *
 * @link       http://vipercache.com
 * @since      2.0.1
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( defined( 'DISQUS_VERSION' ) ) {
  add_filter( 'viper_cache_excluded_js_files', 'viper_cache_exclude_disqus_js' );
}

/**
 * Add Disqus JS files to exclude list
 *
 * @param array $js_files An array of excluded JS files.
 * @return array Updated array of excluded JS files.
 */
function viper_cache_exclude_disqus_js( $js_files ) {

	$js_files[] = str_replace( home_url(), '', plugins_url( '/disqus-comment-system/media/js/disqus.js' ) );
	$js_files[] = str_replace( home_url(), '', plugins_url( '/disqus-comment-system/media/js/count.js' ) );
    
  return $js_files;

}
