<?php
/**
 * Handles compatibility with Divi Theme, adds various files to excluded JS Files list
 *
 * @link       http://vipercache.com
 * @since      2.0.1
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

add_filter( 'viper_cache_excluded_js_files', 'viper_cache_exclude_divi_js' );

/**
 * Add Divi JS files to exclude list
 *
 * @param array $js_files An array of excluded JS files.
 * @return array Updated array of excluded JS files.
 */
function viper_cache_exclude_divi_js( $js_files ) {

  if ( defined( 'ET_BUILDER_URI' ) ) {
  	$js_files[] = str_replace( home_url(), '', ET_BUILDER_URI ) . '/scripts/salvattore.min.js';
  }

  return $js_files;

}
