<?php
/**
 * Handles compatibility with Easy Digital Downloads, adds various pages to rejected uri list
 * and clear the cache for any effecting changes made by EDD
 *
 * @link       http://vipercache.com
 * @since      2.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( function_exists( 'EDD' ) ) {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_edd_pages' );
	add_action( 'update_option_edd_settings', 'CYB_Viper_Cache::after_update_array_options', 10, 2 );
}

/**
 * Exclude EDD pages from cache
 *
 * @param array $urls An array of excluded pages.
 * @return array Updated array of excluded pages
 */
function viper_cache_exclude_edd_pages( $urls ) {

	$edd_settings = get_option( 'edd_settings' );

	if ( isset( $edd_settings['purchase_page'] ) ) {
			$checkout_urls = CYB_Viper_Cache::get_post_url_path( $edd_settings['purchase_page'], 'page', '(.*)' );

			$urls = array_unique (array_merge( $urls, $checkout_urls ));
	}

	return $urls;
}

/**
 * Update rejected uri on activation /  deactivation
 *
 */
function viper_cache_activate_edd() {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_edd_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'activate_easy-digital-downloads/easy-digital-downloads.php', 'viper_cache_activate_edd', 11 );


function viper_cache_deactivate_edd() {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_edd_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'deactivate_easy-digital-downloads/easy-digital-downloads.php', 'viper_cache_deactivate_edd', 11 );
