<?php
/**
 * Handles compatibility with Jigoshop, adds various pages to rejected uri list
 * and clear the cache for any effecting changes made by Jigoshop
 *
 * @link       http://vipercache.com
 * @since      2.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( defined( 'JIGOSHOP_VERSION' ) && function_exists( 'jigoshop_get_page_id' ) ) {
	add_filter( 'viper_cache_reject_uri'       , 'viper_cache_exclude_jigoshop_pages' );
	add_action( 'update_option_jigoshop_options', 'CYB_Viper_Cache::after_update_array_options', 10, 2 );
}

/**
 * Exclude Jigoshop pages from cache.
 *
 * @param array $urls An array of excluded pages.
 * @return array Updated array of excluded pages
 */
function viper_cache_exclude_jigoshop_pages( $urls ) {

	if ( jigoshop_get_page_id( 'checkout' ) && jigoshop_get_page_id( 'checkout' ) !== '-1' ) {
		$checkout_urls = CYB_Viper_Cache::get_post_url_path( jigoshop_get_page_id( 'checkout' ), 'page', '(.*)' );
		$urls = array_unique (array_merge( $urls, $checkout_urls ));
	}

	if ( jigoshop_get_page_id( 'cart' ) && jigoshop_get_page_id( 'cart' ) !== '-1' ) {
		$checkout_urls = CYB_Viper_Cache::get_post_url_path( jigoshop_get_page_id( 'cart' ) );
		$urls = array_unique (array_merge( $urls, $checkout_urls ));
	}

	if ( jigoshop_get_page_id( 'myaccount' ) && jigoshop_get_page_id( 'myaccount' ) !== '-1' ) {
		$checkout_urls = CYB_Viper_Cache::get_post_url_path( jigoshop_get_page_id( 'myaccount' ), 'page', '(.*)' );
		$urls = array_unique (array_merge( $urls, $checkout_urls ));
	}

	return $urls;
}

/**
 * Update rejected uri on activation /  deactivation
 */
function viper_cache_activate_jigoshop() {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_jigoshop_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'activate_jigoshop/jigoshop.php', 'viper_cache_activate_jigoshop', 11 );

/**
 * Remove Jigoshop pages from cache exclusion on plugin deactivation.
 */
function viper_cache_deactivate_jigoshop() {
	remove_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_jigoshop_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'deactivate_jigoshop/jigoshop.php', 'viper_cache_deactivate_jigoshop', 11 );
