<?php
/**
 * Handles compatibility with woocommerce, adds various pages to rejected uri list
 * and clear the cache for any effecting changes made by WooCommerce
 *
 * @link       http://vipercache.com
 * @since      2.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( class_exists( 'WooCommerce' ) ) {

	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_woocommerce_pages' );

	add_action( 'update_option_woocommerce_cart_page_id'            , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_woocommerce_checkout_page_id'        , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_woocommerce_myaccount_page_id'       , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_filter( 'update_option_woocommerce_default_customer_address', 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'woocommerce_ajax_save_product_variations'          , 'viper_cache_clean_cache_after_woocommerce_save_product_variation', 10 );

}

/**
 * Clean product cache on variation update
 *
 * @param int $product_id ID of the variation.
 */
function viper_cache_clean_cache_after_woocommerce_save_product_variation( $product_id ) {

		CYB_Viper_Cache::action_publishPost( $product_id );
}

/**
 * Exclude WooCommerce cart, checkout and account pages from caching
 *
 * @param array $urls An array of excluded pages.
 * @return array Updated array of excluded pages
 */
function viper_cache_exclude_woocommerce_pages( $urls ) {

	if ( function_exists( 'WC' ) && function_exists( 'wc_get_page_id' ) ) {

		if ( wc_get_page_id( 'checkout' ) && wc_get_page_id( 'checkout' ) !== -1 && wc_get_page_id( 'checkout' ) !== (int) get_option( 'page_on_front' ) ) {
			$checkout_urls = CYB_Viper_Cache::get_post_url_path( wc_get_page_id( 'checkout' ), 'page', '(.*)' );
			$urls = array_unique (array_merge( $urls, $checkout_urls ));
		}

		if ( wc_get_page_id( 'cart' ) && wc_get_page_id( 'cart' ) !== -1 && wc_get_page_id( 'cart' ) !== (int) get_option( 'page_on_front' ) ) {
			$cart_urls = CYB_Viper_Cache::get_post_url_path( wc_get_page_id( 'cart' ) );
			$urls = array_unique (array_merge( $urls, $cart_urls ));
		}

		if ( wc_get_page_id( 'myaccount' ) && wc_get_page_id( 'myaccount' ) !== -1 && wc_get_page_id( 'myaccount' ) !== (int) get_option( 'page_on_front' ) ) {
			$cart_urls = CYB_Viper_Cache::get_post_url_path( wc_get_page_id( 'myaccount' ), 'page', '(.*)' );
			$urls = array_unique (array_merge( $urls, $cart_urls ));
		}
	}

	return $urls;
}

/**
 * Update rejected uri on activation /  deactivation
 *
 */
function viper_cache_activate_woocommerce() {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_woocommerce_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'activate_woocommerce/woocommerce.php', 'viper_cache_activate_woocommerce', 11 );

function viper_cache_deactivate_woocommerce() {
	remove_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_woocommerce_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();

}

add_action( 'deactivate_woocommerce/woocommerce.php', 'viper_cache_deactivate_woocommerce', 11 );

if ( class_exists( 'WC_API' ) ) {
	/**
	 * Exclude WooCommerce REST API URL from cache
	 *
	 * @since 2.0.0
	 *
	 * @param array $uri URLs to exclude from cache.
	 * @return array Updated list of URLs to exclude from cache
	 */
	function viper_cache_exclude_wc_rest_api( $uri ) {

		$viper_cache_cache_reject_wc_rest_api = apply_filters( 'viper_cache_reject_wc_rest_api', true );

		// Exclude WooCommerce REST API.
		if ( $viper_cache_cache_reject_wc_rest_api ) {
			$uri[] = _get_component_from_parsed_url_array( wp_parse_url( home_url( '/wc-api/v(.*)' ) ), PHP_URL_PATH );
      $uri = array_unique ($uri);
		}

		return $uri;
	}

  add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_wc_rest_api' );

}
