<?php
/**
 * Handles compatibility with WP REST API, adds various pages to rejected uri list
 *
 * @link       http://vipercache.com
 * @since      2.0.1
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_wp_rest_api_pages' );

/**
 * Exclude WP REST API path from cache
 *
 * @param array $urls An array of excluded pages.
 * @return array Updated array of excluded pages
 */
function viper_cache_exclude_wp_rest_api_pages( $urls ) {

	// Exclude WP REST API.
	if ( function_exists( 'json_get_url_prefix' ) ) {
		$urls[] = '/' . json_get_url_prefix() . '/(.*)';
	}

	if ( class_exists( 'WP_REST_Controller' ) ) {
		$urls[] = '/wp-json/(.*)';
	}

	return $urls;
}
