<?php
/**
 * Handles compatibility with WPShop, adds various pages to rejected uri list
 * and clear the cache for any effecting changes made by WPShop
 *
 * @link       http://vipercache.com
 * @since      2.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/includes/third-party/plugins
 */
defined( 'ABSPATH' ) || die( 'Tsk Tsk' );

if ( defined( 'WPSHOP_VERSION' ) && class_exists( 'wpshop_tools' ) && method_exists( 'wpshop_tools','get_page_id' ) ) {

	add_filter( 'viper_cache_reject_uri'                         , 'viper_cache_exclude_wpshop_pages' );
	add_action( 'update_option_wpshop_cart_page_id'              , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_wpshop_checkout_page_id'          , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_wpshop_payment_return_page_id'    , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_wpshop_payment_return_nok_page_id', 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
	add_action( 'update_option_wpshop_myaccount_page_id'         , 'CYB_Viper_Cache::after_update_single_options', 10, 2 );
}


/**
 * Exclude WP Shop pages from cache.
 *
 * @param array $urls An array of excluded pages.
 * @return array Updated array of excluded pages
 */
function viper_cache_exclude_wpshop_pages( $urls ) {
	$pages = array(
		'wpshop_cart_page_id',
		'wpshop_checkout_page_id',
		'wpshop_payment_return_page_id',
		'wpshop_payment_return_nok_page_id',
		'wpshop_myaccount_page_id',
	);

	foreach ( $pages as $page ) {
		$page_id = wpshop_tools::get_page_id( get_option( $page ) );
		if ( $page_id ) {
			$urls = array_merge( $urls, CYB_Viper_Cache::get_post_url_path( $page_id ) );
		}
	}

	$urls = array_unique ($urls);

	return $urls;
}

/**
 * Exclude WP Shop pages from cache on plugin activation.
 */
function viper_cache_activate_wpshop() {
	add_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_wpshop_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'activate_wpshop/wpshop.php', 'viper_cache_activate_wpshop', 11 );

/**
 * Remove WP Shop pages from cache exclusion on plugin deactivation.
 */
function viper_cache_deactivate_wpshop() {
	remove_filter( 'viper_cache_reject_uri', 'viper_cache_exclude_wpshop_pages' );

	// Regenerate the uri not to cache
	CYB_Viper_Cache::update_3rdparty_reject_uri();
}
add_action( 'deactivate_wpshop/wpshop.php', 'viper_cache_deactivate_wpshop', 11 );
