<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://vipercache.com
 * @since      1.0.0
 *
 * @package    ViperCache
 * @subpackage ViperCache/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    ViperCache
 * @subpackage ViperCache/public
 * @author     Your Name <email@example.com>
 */
class ViperCache_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * An instance of the settings handler class
	 * @since    1.0.0
	 * @access   private
	 * @var      class     $settings    The current instance of the settings handler.
	 */
	private $settings;

	/**
	 * The general settings
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $settings    The current settings of this plugin.
	 */
	private $gen_settings;

	/**
	 * The site cache settings
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $sitecache_settings    The current site cache settings of this plugin.
	 */
	public $sitecache_settings;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		$this->settings = new ViperCache_Settings( $plugin_name, $version );
		$this->gen_settings = $this->settings->get_settings();
    $this->sitecache_settings = $this->settings->get_sitecache_settings();

    $this->setup_caching($this->sitecache_settings);
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		global $viper_cache_asset_suffix;
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in ViperCache_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The ViperCache_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/vipercache-public' . $viper_cache_asset_suffix . '.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		global $viper_cache_asset_suffix;
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in ViperCache_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The ViperCache_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/criticalCSS' . $viper_cache_asset_suffix . '.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function setup_caching($sitecache_settings) {
    $cybCache = new CYB_Viper_Cache();
		$cybCache->setupCaching($sitecache_settings);
  }

  function defer_parsing_of_js ( $tag, $handle, $src ) {

    if(is_admin() ) return $tag;
    if(preg_match("/jquery(|.min).js/i", $src) == 1)  return $tag;

		$tag = str_replace( 'src=', "defer src=", $tag );

    return $tag;
  }

  /**
   * Disables the WordPress emojis
   */
	public function disable_emojis(){
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		remove_action('admin_print_scripts', 'print_emoji_detection_script');
		remove_filter('the_content_feed', 'wp_staticize_emoji');
		remove_filter('comment_text_rss', 'wp_staticize_emoji');
		remove_action('wp_print_styles', 'print_emoji_styles');
		remove_action('admin_print_styles', 'print_emoji_styles');
		remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
	}

  /**
   * Removes the `ver` query string from the source filename.
   * Doesn't change admin scripts/styles and sources
   * with more than the `ver` arg.
   *
   * @param  string $src The original source.
   * @return string
   */
  function remove_version_from_query_string( $src ) {
  	// Don't touch admin scripts.
  	if ( is_admin() ) {
  		return $src;
  	}

    if(!CYB_Viper_Cache::isCachable()) {
      return $src;
    }

  	$_src = $src;
  	if ( '//' === substr( $_src, 0, 2 ) ) {
      $_src = (CYB_Viper_Cache::isHTTPSPage() ? 'https:' : 'http:')  . $_src;

  	}
  	$_src = parse_url( $_src );
  	// Give up if malformed URL.
  	if ( false === $_src ) {
  		return $src;
  	}

  	// Check if it's a local URL.
  	$wp = parse_url( home_url() );
  	if ( isset( $_src['host'] ) && $_src['host'] !== $wp['host'] ) {
  		return $src;
  	}

    $src = remove_query_arg( array('ver', 'version', 'v', 'rev'), $src );

    return $src;
  }

}
