// javascript: void (function () {
(function (win, doc) {
  "use strict";
  function matchMedia(mediaRule) {
    return win.matchMedia(mediaRule.media.mediaText).matches;
  }
  function matchesSelector(el, selector) {
    var matchesSelector =
        el.matchesSelector ||
        el.webkitMatchesSelector ||
        el.mozMatchesSelector ||
        el.msMatchesSelector,
      matches,
      len;
    if (matchesSelector)
      try {
        return matchesSelector.call(el, selector);
      } catch (_) {
        return false;
      }
    else {
      matches = el.ownerDocument.querySelectorAll(selector);
      len = matches.length;
      while (len--) if (matches[len] === el) return true;
    }
    return false;
  }
  function getMatchedCSSRules(el) {
    var matchedRules = [],
      sheets = el.ownerDocument.styleSheets,
      slen = sheets.length,
      rlen,
      rules,
      mrules,
      mrlen,
      rule,
      mediaMatched;
    if (el.nodeType === 1) {
      while (slen--) {
        try {
          rules = sheets[slen].cssRules;
        } catch (_) {
          rules = "";
        }
        try {
          rules = rules || sheets[slen].rules;
        } catch (_) {
          continue;
        }
        rlen = rules.length;
        while (rlen--) {
          rule = rules[rlen];
          if (
            rule instanceof CSSStyleRule &&
            matchesSelector(el, rule.selectorText)
          )
            matchedRules.push(rule);
          else if (rule instanceof CSSMediaRule)
            if (matchMedia(rule)) {
              mrules = rule.cssRules || rule.rules;
              mrlen = mrules.length;
              while (mrlen--) {
                rule = mrules[mrlen];
                if (
                  rule instanceof CSSStyleRule &&
                  matchesSelector(el, rule.selectorText)
                )
                  matchedRules.push(rule);
              }
            }
        }
      }
    }
    return matchedRules;
  }
  function CSSCriticalPath(w, d, opts) {
    if (!(this instanceof CSSCriticalPath))
      return new CSSCriticalPath(w, d, opts);
    var opt = opts || {},
      css = {};
    function pushCSS(r) {
      var styles = r.style.cssText.split(splitRegex),
        i = styles.length,
        pair;
      css[r.selectorText] = css[r.selectorText] || {};
      while (i--) {
        if (!styles[i]) continue;
        pair = styles[i].split(": ");
				if(pair[0])
        	pair[0] = pair[0].trim();
				if(pair[1])
        	pair[1] = pair[1].trim();
        css[r.selectorText][pair[0]] = pair[1];
      }
    }
    function parseTree() {
      var height = w.innerHeight,
        walker = d.createTreeWalker(
          d,
          NodeFilter.SHOW_ELEMENT,
          function (node) {
            return NodeFilter.FILTER_ACCEPT;
          },
          true
        ),
        node,
        rect,
        rules,
        r;
      while (walker.nextNode()) {
        node = walker.currentNode;
        rect = node.getBoundingClientRect();
        if (rect.top < height || opt.scanFullPage) {
          rules = getMatchedCSSRules(node);
          r = rules.length;
          if (!!rules) while (r--) pushCSS(rules[r]);
        }
      }
    }
    function generateCSS() {
      var finalCSS = "",
        k,
        j;
      for (k in css)
        if (css.hasOwnProperty(k)) {
          finalCSS += k + " { ";
          for (j in css[k])
            if (css[k].hasOwnProperty(j))
              finalCSS += j + ": " + css[k][j] + ";";
          finalCSS += "}\n";
        }
      return finalCSS;
    }
    this.generateCSS = generateCSS;
    parseTree();
  }
  var splitRegex = /;(?![A-Za-z0-9])/,
    cp = new CSSCriticalPath(win, doc),
    css = cp.generateCSS();
  console.log("==> VIPER CACHE START OF CRITICAL CSS vvvvvv");
  console.log(css);
  console.log("==> VIPER CACHE END OF CRITICAL CSS ^^^^^^");
  return false;
})(window, document);
// })();
