<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://vipercache.com
 * @since             1.0.0
 * @package           ViperCache
 *
 * @wordpress-plugin
 * Plugin Name:       ViperCache
 * Plugin URI:        http://vipercache.com/
 * Description:       10x your page load speed with Viper Cache engine...built from the ground up to give you total ease of use & minimum user input & maximum security.
 * Version:           2.1
 * Author:            WP Toolkit
 * Author URI:        https://wptoolkit.com
 * Text Domain:       vipercache
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define('CYBVC_PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('CYBVC_PLUGIN_FILE', __FILE__ );
define('CYBVC_SLUG', 'vipercache' );

/**
 * This value represent the current version of the layout of the database tables. This value
 * needs to be increased every time you change something in your database layout.
 * @var integer
 */
global $viper_cache_db_version;
$viper_cache_db_version = '1.0';

/**
 * If the global WP SCRIPT_DEBUG is defined then use the uncompressed versions of JS & CSS Files
 * otherwise the minimised version are used
 * @var integer
 */
global $viper_cache_asset_suffix;
$viper_cache_asset_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';


/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-vipercache-activator.php
 */
function activate_viper_cache() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-vipercache-activator.php';
	ViperCache_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-vipercache-deactivator.php
 */
function deactivate_viper_cache() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-vipercache-deactivator.php';
	ViperCache_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_viper_cache' );
register_deactivation_hook( __FILE__, 'deactivate_viper_cache' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-vipercache.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_viper_cache() {

	$plugin = new ViperCache();
	$plugin->run();

}
run_viper_cache();
